/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.particle;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.client.particle.ParticleBubbleTFC;
import net.dries007.tfc.client.particle.ParticleFirePitSmoke;
import net.dries007.tfc.client.particle.ParticleLeaf;
import net.dries007.tfc.client.particle.ParticleSpark;
import net.dries007.tfc.client.particle.ParticleSteam;
import net.dries007.tfc.network.PacketSpawnTFCParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="tfc")
public enum TFCParticles {
    STEAM(new ResourceLocation("tfc", "particle/steam"), () -> ParticleSteam::new),
    FIRE_PIT_SMOKE1(new ResourceLocation("tfc", "particle/fire_pit_smoke1"), () -> ParticleFirePitSmoke::new),
    FIRE_PIT_SMOKE2(new ResourceLocation("tfc", "particle/fire_pit_smoke2"), () -> ParticleFirePitSmoke::new),
    FIRE_PIT_SMOKE3(new ResourceLocation("tfc", "particle/fire_pit_smoke3"), () -> ParticleFirePitSmoke::new),
    LEAF1(new ResourceLocation("tfc", "particle/leaf1"), () -> ParticleLeaf::new),
    LEAF2(new ResourceLocation("tfc", "particle/leaf2"), () -> ParticleLeaf::new),
    LEAF3(new ResourceLocation("tfc", "particle/leaf3"), () -> ParticleLeaf::new),
    SPARK(new ResourceLocation("tfc", "particle/spark"), () -> ParticleSpark::new),
    BUBBLE(new ResourceLocation("tfc", "particle/bubble"), () -> ParticleBubbleTFC::new);

    private final ResourceLocation location;
    private final Supplier<IParticleFactoryTFC> factorySupplier;
    private TextureAtlasSprite sprite;

    @SubscribeEvent
    public static void onTextureStitchEvent(TextureStitchEvent.Pre event) {
        for (TFCParticles particle : TFCParticles.values()) {
            particle.registerSprite(event.getMap());
        }
    }

    private TFCParticles(ResourceLocation location, Supplier<IParticleFactoryTFC> factorySupplier) {
        this.location = location;
        this.factorySupplier = factorySupplier;
    }

    @SideOnly(value=Side.CLIENT)
    public void spawn(World worldIn, double x, double y, double z, double speedX, double speedY, double speedZ, int duration) {
        Particle particle = this.factorySupplier.get().createParticle(worldIn, x, y, z, speedX, speedY, speedZ, duration);
        particle.func_187117_a(this.sprite);
        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
    }

    public void sendToAllNear(World worldIn, double x, double y, double z, double speedX, double speedY, double speedZ, int duration) {
        int range = 80;
        PacketSpawnTFCParticle packet = new PacketSpawnTFCParticle(this, x, y, z, speedX, speedY, speedZ, duration);
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(worldIn.field_73011_w.getDimension(), x, y, z, 80.0);
        TerraFirmaCraft.getNetwork().sendToAllAround((IMessage)packet, point);
    }

    @SideOnly(value=Side.CLIENT)
    private void registerSprite(@Nonnull TextureMap map) {
        this.sprite = map.func_174942_a(this.location);
    }

    public static interface IParticleFactoryTFC {
        @SideOnly(value=Side.CLIENT)
        @Nonnull
        public Particle createParticle(World var1, double var2, double var4, double var6, double var8, double var10, double var12, int var14);
    }
}

